/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.Button;
import control.MenuControl;
import data.Constants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import view.Fonts;

public class ScoreControl {
    private File highScores;
    private ArrayList<SongScores> scoreList = new ArrayList();
    private boolean found = false;
    private boolean enter = false;
    private ArrayList<String> tplayers;
    private ArrayList<Integer> scrs;
    private Button menuButt = new Button(-Constants.VIEW_WIDTH / 6, (int)((double)(Constants.VIEW_HEIGHT / 7) * 3.5), "Menu", 1.0f);

    ScoreControl() {
    }

    public void update() {
        if (!this.enter) {
            this.findSong();
            this.enter = true;
        }
        this.menuButt.draw();
        if (this.menuButt.checkCollision(Constants.VIEW_WIDTH / 2, Constants.VIEW_HEIGHT / 2)) {
            Constants.currentGameState = 0;
        }
        this.draw();
    }

    public void reset() {
        this.enter = false;
        this.found = false;
    }

    public void initializeFile() {
        this.highScores = new File("MusicDotsHighScores.txt");
        if (this.highScores.isFile()) {
            try {
                String line;
                FileInputStream fstream = new FileInputStream(this.highScores);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((line = br.readLine()) != null) {
                    int i;
                    int j = line.indexOf(58);
                    if (j < 0) continue;
                    String songName = line.substring(0, j);
                    SongScores temp = new SongScores(songName);
                    while ((i = line.indexOf(45, j)) >= 0) {
                        String tmpPlayer = line.substring(j + 1, i);
                        j = line.indexOf(63, i);
                        if (j < 0) break;
                        String tmpScore = line.substring(i + 1, j);
                        temp.addScore(tmpPlayer, Integer.parseInt(tmpScore));
                        if (j != line.length() - 1) continue;
                    }
                    this.scoreList.add(temp);
                }
                in.close();
                br.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void writeToFile() {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.highScores, false));
            for (SongScores s : this.scoreList) {
                bw.write(String.valueOf(s.toString()) + "\n");
            }
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addNewScore(String playerName, int score) {
        for (SongScores s : this.scoreList) {
            if (!Constants.SONG_TO_USE.equals(s.getSongName())) continue;
            s.addScore(playerName, score);
            return;
        }
        SongScores temp = new SongScores(Constants.SONG_TO_USE);
        temp.addScore(playerName, score);
        this.scoreList.add(temp);
        this.reset();
    }

    private void findSong() {
        int i = 0;
        while (i < this.scoreList.size()) {
            if (Constants.SONG_TO_USE.equals(this.scoreList.get(i).getSongName())) {
                this.tplayers = this.scoreList.get(i).getTopPlayers();
                this.scrs = this.scoreList.get(i).getTopScores();
                this.found = true;
                break;
            }
            ++i;
        }
    }

    private void draw() {
        Fonts.drawText((float)(Constants.VIEW_WIDTH / 2) + MenuControl.offsetX - (float)Constants.VIEW_WIDTH, (float)(Constants.VIEW_HEIGHT / 8) + MenuControl.offsetY, 1.0, Constants.SONG_TO_USE, true);
        if (this.found) {
            int i = 0;
            while (i < this.tplayers.size()) {
                Fonts.drawText((float)(Constants.VIEW_WIDTH * 80) * Fonts.resolutionScale / 800.0f + MenuControl.offsetX - (float)Constants.VIEW_WIDTH, 150.0f + 40.0f * Fonts.resolutionScale * (float)i + MenuControl.offsetY, 0.6, String.valueOf(Integer.toString(i + 1)) + ")", false);
                Fonts.drawText((float)(Constants.VIEW_WIDTH * 140) * Fonts.resolutionScale / 800.0f + MenuControl.offsetX - (float)Constants.VIEW_WIDTH, 150.0f + 40.0f * Fonts.resolutionScale * (float)i + MenuControl.offsetY, 0.6, this.tplayers.get(i), false);
                Fonts.drawText((float)(Constants.VIEW_WIDTH * 400) * Fonts.resolutionScale / 800.0f + MenuControl.offsetX - (float)Constants.VIEW_WIDTH, 150.0f + 40.0f * Fonts.resolutionScale * (float)i + MenuControl.offsetY, 0.6, Integer.toString(this.scrs.get(i)), false);
                ++i;
            }
        } else {
            Fonts.drawText((float)(Constants.VIEW_WIDTH / 2) + MenuControl.offsetX - (float)Constants.VIEW_WIDTH, 150.0f + MenuControl.offsetY, 1.0, "No High Scores", true);
        }
    }

    private class SongScores {
        private String songName;
        private ArrayList<String> topPlayers;
        private ArrayList<Integer> scores;

        SongScores(String songName) {
            this.songName = songName;
            this.topPlayers = new ArrayList();
            this.scores = new ArrayList();
        }

        public boolean addScore(String player, int score) {
            if (this.scores.size() == 0) {
                this.scores.add(score);
                this.topPlayers.add(player);
                return true;
            }
            int i = 0;
            while (i < this.scores.size()) {
                if (score > this.scores.get(i)) {
                    this.scores.add(i, score);
                    this.topPlayers.add(i, player);
                    System.out.println(this.scores.size());
                    if (this.scores.size() == 11) {
                        this.scores.remove(10);
                        this.topPlayers.remove(10);
                    }
                    return true;
                }
                ++i;
            }
            if (this.scores.size() < 10) {
                this.scores.add(score);
                this.topPlayers.add(player);
                return true;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.songName);
            sb.append(':');
            int i = 0;
            while (i < this.topPlayers.size()) {
                sb.append(this.topPlayers.get(i));
                sb.append('-');
                sb.append(this.scores.get(i));
                sb.append('?');
                ++i;
            }
            return sb.toString();
        }

        public ArrayList<String> getTopPlayers() {
            return this.topPlayers;
        }

        public ArrayList<Integer> getTopScores() {
            return this.scores;
        }

        public String getSongName() {
            return this.songName;
        }
    }
}

